from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math
import LuTze

class BoxArena(Arenas.SuperArena):
    "Robot Wars Arena, don't drop into the pit, mind the flipper and don't stay in the dropzone too long."
    name = "Robot Wars Arena"
    preview = "lt_rwarena/rwarena_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-21, 17, 22, -18)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/lt_rwarena/rwarena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        
        degrad = 0.01745
	self.AddStaticCamera("Craig Charles Cam", (-22, 18, 0), (50*degrad,math.pi/2), 80*degrad)
	self.AddStaticCamera("Center Cam 1", (0, 8, -18), (35*degrad,0*degrad), 70*degrad)
	#self.AddStaticCamera("Center Cam 2", (0, 8, 18), (35*degrad,180*degrad), 70*degrad)
	self.AddStaticCamera("Corner Cam 1", (18, 20, 16), (45*degrad,212*degrad), 50*degrad)
	self.AddStaticCamera("Corner Cam 2", (-18, 20, 16), (45*degrad,122*degrad), 50*degrad)
	self.AddStaticCamera("Top Cam", (00, 20, 0), (90*degrad,math.pi), 80*degrad)
	self.AddStaticCamera("Fridge Cam", (12, 38, 8), (67*degrad,225*degrad), 50*degrad)
	self.AddWatchCamera("Watch Cam 1", (-24, 15, 18), (12, 20, 30*degrad, 20*degrad))
	self.AddWatchCamera("Watch Cam 2", (24, 15, -18), (12, 20, 30*degrad, 20*degrad))
	self.AddWatchCamera("Watch Cam 3", (10, 20, 10), (14, 22, 30*degrad, 30*degrad))
	self.AddWatchCamera("Watch Cam 4", (-10, 20, -10), (16, 24, 30*degrad, 40*degrad))
	self.dropstart = 0
	self.droptimer = 0
        self.players = ()
        

        
    def AddShadowReceivers(self):
        self.SetShadowSource(0, 19.159, 0)
        
        #Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.063,1.83754), (-12.4182,0.063,12.4283), (-12.4182,0.063,1.83754))
        self.AddShadowTriangle((-8.17686,0.063,9.91855), (-8.17686,0.063,12.4283), (-12.4182,0.063,12.4283))
        self.AddShadowTriangle((-8.17686,0.063,9.91855), (-12.4182,0.063,12.4283), (-10.2877,0.063,1.83754))
        self.AddShadowTriangle((2.25999,0.063,12.4283), (-2.49123,0.063,12.4283), (-2.49123,0.063,9.91855))
        self.AddShadowTriangle((2.25999,0.063,9.91855), (2.25999,0.063,12.4283), (-2.49123,0.063,9.91855))
        self.AddShadowTriangle((12.413,0.063,12.4283), (7.93297,0.063,12.4283), (7.93297,0.063,9.91855))
        self.AddShadowTriangle((10.2878,0.063,1.91641), (12.413,0.063,12.4283), (7.93297,0.063,9.91855))
        self.AddShadowTriangle((10.2878,0.063,1.91641), (12.413,0.063,1.91641), (12.413,0.063,12.4283))
        self.AddShadowTriangle((8.17711,0.063,-9.92447), (12.413,0.063,-12.4279), (10.2878,0.063,-1.93329))
        self.AddShadowTriangle((10.2878,0.063,-1.93329), (12.413,0.063,-12.4279), (12.413,0.063,-1.93329))
        self.AddShadowTriangle((8.17711,0.063,-9.92447), (8.17711,0.063,-12.4279), (12.413,0.063,-12.4279))
        self.AddShadowTriangle((-2.26871,0.063,-12.4279), (2.49519,0.063,-12.4279), (2.49519,0.063,-9.92447))
        self.AddShadowTriangle((-2.26871,0.063,-9.92447), (-2.26871,0.063,-12.4279), (2.49519,0.063,-9.92447))
        self.AddShadowTriangle((-12.4182,0.063,-12.4279), (-7.93688,0.063,-12.4279), (-7.93688,0.063,-9.92447))
        self.AddShadowTriangle((-10.2877,0.063,-1.8361), (-12.4182,0.063,-12.4279), (-7.93688,0.063,-9.92447))
        self.AddShadowTriangle((-10.2877,0.063,-1.8361), (-12.4182,0.063,-1.8361), (-12.4182,0.063,-12.4279))
        self.AddShadowTriangle((-2.49123,0.063,9.91855), (-8.17686,0.063,9.91855), (-10.2877,0.063,1.83754))
        self.AddShadowTriangle((2.49519,0.063,-9.92447), (8.17711,0.063,-9.92447), (10.2878,0.063,-1.93329))
        self.AddShadowTriangle((10.2878,0.063,-1.93329), (-10.2877,0.063,-1.8361), (-2.26871,0.063,-9.92447))
        self.AddShadowTriangle((10.2878,0.063,1.91641), (7.93297,0.063,9.91855), (2.25999,0.063,9.91855))
        self.AddShadowTriangle((2.25999,0.063,9.91855), (-2.49123,0.063,9.91855), (-10.2877,0.063,1.83754))
        self.AddShadowTriangle((10.2878,0.063,1.91641), (2.25999,0.063,9.91855), (-10.2877,0.063,1.83754))
        self.AddShadowTriangle((10.2878,0.063,-1.93329), (10.2878,0.063,1.91641), (-10.2877,0.063,1.83754))
        self.AddShadowTriangle((-10.2877,0.063,-1.8361), (10.2878,0.063,-1.93329), (-10.2877,0.063,1.83754))
        self.AddShadowTriangle((-2.26871,0.063,-9.92447), (2.49519,0.063,-9.92447), (10.2878,0.063,-1.93329))
        self.AddShadowTriangle((-10.2877,0.063,-1.8361), (-7.93688,0.063,-9.92447), (-2.26871,0.063,-9.92447))
        

    def HazardsOn(self, on):
	if on:
	    self.flame1 = Hazards.Flame((-11.0, -.6, -11.6), (0, 5, 0), (.8, .8, .8), .8)
	    self.AddHazard(self.flame1)
	    self.flame2 = Hazards.Flame((-11.2, -.6, 11.0), (0, 5, 0), (.8, .8, .8), .8)
	    self.AddHazard(self.flame2)
	    self.flame3 = Hazards.Flame((11.2, -.6, 11.0 ), (0, 5, 0), (.8, .8, .8), .8)
	    self.AddHazard(self.flame3)
	    self.flame4 = Hazards.Flame((11.4, -.6, -11.3), (0, 5, 0), (.8, .8, .8), .8)
	    self.AddHazard(self.flame4)
	    self.flame5 = Hazards.Flame((-3.42, -.6, 3.9), (0, 5, 0), (.8, .8, .8), .8)
	    self.AddHazard(self.flame5)
	    self.flame6a = Hazards.Flame((-2.809, -.6, 10.342), (0, 5, 0), (.2, .4, .2), .8)
	    self.AddHazard(self.flame6a)
	    self.flame6b = Hazards.Flame((-2.809, -.6, 11.342), (0, 5, 0), (.2, .4, .2), .8)
	    self.AddHazard(self.flame6b)
	    self.flame6c = Hazards.Flame((-3.809, -.6, 10.342), (0, 5, 0), (.2, .4, .2), .8)
	    self.AddHazard(self.flame6c)
	    self.flame6d = Hazards.Flame((-3.809, -.6, 11.342), (0, 5, 0), (.2, .4, .2), .8)
	    self.AddHazard(self.flame6d)
	    self.RegisterZone("sfz5",8)
	    self.RegisterZone("lfz",9)
	    prism = self.AddPrismatic("arena_collision", "pitcover", 0, 1, 0, 0, -5, 0)
            self.lift1 = LuTze.Saws(prism, (1,1,2))
	    self.AddHazard(self.lift1)
            hinge = self.GetHinge("fliphinge")
            self.RegisterZone("flipzone", 5)
            self.Hell1 = LuTze.HellRaiser(hinge, (8, 0, 4))
            self.AddHazard(self.Hell1)
	    self.SetActive("fridge", False)
	    self.SetActive("saws", False)
    	    self.RegisterZone("dropzone",6)
	    self.RegisterZone("sfz2",1)
	    self.RegisterZone("sfz1",2)
	    self.RegisterZone("sfz4",3)
	    self.RegisterZone("sfz3",4)
	    self.RegisterZone("pitzone",7)
            self.SetSubMaterialSound("fridge", "metal", 4.0, "Sounds\\hzd_comp_hit.wav")
            self.SetSubMaterialSound("saws", "metal", 8.0, "Sounds\\sawblade_hits_loop.wav")

            # Pit avoidance
            self.AddCollisionLine((8, 6), (12,6))
            self.AddCollisionLine((12, 6), (12, 2))
            self.AddCollisionLine((12, 2), (8, 2))
            self.AddCollisionLine((8, 2), (8, 6))
            self.AddCollisionLine((7.8, 6.2), (12.2, 6.2))
            self.AddCollisionLine((12.2, 6.2), (12.2, 1.8))
            self.AddCollisionLine((12.2, 1.8), (7.8, 1.8))
            self.AddCollisionLine((7.8, 1.8), (7.8, 6.2))
            self.AddCollisionLine((7.9, 6.1), (12.1, 6.1))
            self.AddCollisionLine((12.1, 6.1), (12.1, 1.9))
            self.AddCollisionLine((12.1, 1.9), (7.1, 1.9))
            self.AddCollisionLine((7.9, 1.9), (7.9, 6.1))
            
            # Drpzone avoidance
            self.AddCollisionLine((-2, -2), (-2, 2))
            self.AddCollisionLine((-2, 2), (2, 2))
            self.AddCollisionLine((2, 2), (2, -2))
            self.AddCollisionLine((2, -2), (-2, -2))
            
            # Flipper avoidance
            self.AddCollisionLine((-12, -2), (-8, -2))
            self.AddCollisionLine((-8, -2), (-8, -6))
            self.AddCollisionLine((-8, -6), (-12, -6))
            self.AddCollisionLine((-12, -6), (-12, -2))

            self.AddPOV(0, (-5.6, -10.1), (0, 2))
            self.AddPOV(1, (-15.5, -9.2), (1, 3))
            self.AddPOV(2, (-15.1, 1.6), (2, 4))
            self.AddPOV(3, (-4.8, 7.6), (0, 3, 5))
            self.AddPOV(4, (5.6, 10.4), (4, 6))
            self.AddPOV(5, (14.9, 8), (5, 7))
            self.AddPOV(6, (14.6, -1.9), (0, 6))
            self.AddPOV(7, (4.0, -6.8), (1, 4, 7))

            
	#walls
	self.AddCollisionLine((18, 14), (18, -14))
	self.AddCollisionLine((18 ,-14 ), (-18 , -14))
	self.AddCollisionLine((-18, -14), (-18, 14))
	self.AddCollisionLine((-18, 14 ), (18, 14))

	return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)

    def Tick(self):
        if self.bHazardsOn:
            self.Hell1.Tick()
	    self.flame1.Tick()
	    self.flame2.Tick()
	    self.flame3.Tick()
	    self.flame4.Tick()
	    self.flame5.Tick()
	    self.flame6a.Tick()
	    self.flame6b.Tick()
	    self.flame6c.Tick()
	    self.flame6d.Tick()
	    self.lift1.Tick()
	    if self.dropstart >=1:
		self.droptimer +=.5
		if self.droptimer == 8: 
		    self.SetActive ("fridge", True)
		if self.droptimer == 20:
		    self.SetPinned ("fridge", True)


        # check to see if anyone has been "eliminated" by falling off the tabletop
        for each in self.players:
            if plus.getLocation(each)[1] < -2:
                plus.eliminatePlayer(each)

        return Arenas.SuperArena.Tick(self)

    def ZoneEvent(self, direction, id, robot, chassis):
        if id ==1:
            self.flame1.ZoneEvent(direction)
	elif id ==2:
	    self.flame2.ZoneEvent(direction)
	elif id ==3:
	    self.flame3.ZoneEvent(direction)
	elif id ==4:
	    self.flame4.ZoneEvent(direction)
        if (id==5 and direction==1):
            self.Hell1.RaiseHell()
	if (id==6 and direction==1):
	    self.dropstart += 1
	if (id==6 and direction==-1):
	    self.dropstart -= 1
	    if self.dropstart ==0:
		self.droptimer = 0
	if (id==7 and direction==1):
	    self.lift1.MoveSaw(1)
	if id ==8:
	    self.flame5.ZoneEvent(direction)
	if id ==9:
	    self.flame6a.ZoneEvent(direction)
	    self.flame6b.ZoneEvent(direction)
	    self.flame6c.ZoneEvent(direction)
	    self.flame6d.ZoneEvent(direction)
	return True

        
Arenas.register(BoxArena)
